<html>
<head>
<title>Paginacija</title>
<style>
	body{font-family: Arial, Helvetica, sans-serif;font-size:14px;}
	div{width:600px;border:1px solid #000000;text-align:center;padding:10px;margin-bottom:10px;}
	.inactive{color:#5F5F5F;font-weight:bold;}
	.active{color:#005700;font-weight:bold;}
	.active:hover{color:#2300FF;}
  </style>
</head>
<body>
<?php
//mozete ukljuciti prikaz gresaka ukoliko je potrebno da debagujete stvari
//error_reporting(E_ALL);
//ini_set("display_errors", 1);

/*------------- povezivanje sa bazom -------------*/

$mysql_hostname = DB_HOST;
$mysql_user = DB_USER;
$mysql_password = DB_PASSWORD;
$mysql_database = DB_NAME;

$konekcija = new PDO('mysql:host='.$mysql_hostname.';dbname='.$mysql_database.';', $mysql_user, $mysql_password);

/*------------- prebrojavanje unosa u bazi - dobijamo ukupan broj -------------*/

$query = $konekcija->prepare("SELECT id FROM pagi");
$query->execute();
$brojunosa = $query->rowCount(); //ukupan broj unosa u bazi

/*------------- podesavanje broja unosa koji ce se prikazivati po (jednoj) strani -------------*/

$prikaz = 4;

/*-------------  deljenjem ukupnog broja unosa i broja unosa koji ce se prikazivati na jednoj strani izracunato je koliko ce strana postojati -------------*/

$strukupno = ceil($brojunosa/$prikaz); //ukoliko deljenje da decimalni rezultat, ceil zaokruzuje broj na prvi najveci

/*-------------  putem GET metode, prosledjujci varijablu page, dobijamo informaciju koja stranica se trenutno prikazuje -------------*/

//$trenutnastr = $_GET['page'] ?? ''; // mozete koristiti ovaj kod umesto sledece linije ako koristite PHP 7 i zelite da izbegnete prikaz greske "Notice: Undefined variable..." kad je ukljucen debugging - ovo se zove null coalesce operator

$trenutnastr = isset($_GET['page']) ? $_GET['page'] : '';

/*-------------  nekoliko pravila koja ce spreciti pozivanje nepostojecih stranica -------------*/

if ($trenutnastr < 1){
    $trenutnastr = 1;
}
elseif ($trenutnastr > $strukupno) {
    $trenutnastr = $strukupno;
}

/*-------------  -1 je neophodno kako bi izbegli prikaz pogresnih unosa na trenutnoj strani, npr. na strani 4 prikazali unose za stranu 5 itd. -------------*/

$poc = ($trenutnastr - 1) * $prikaz; 

$prethodna = $trenutnastr - 1;
$naredna = $trenutnastr + 1;


/*------------- pozivanje unosa iz baze, koristeci PDO statement bindValue -------------*/

echo '<div>';

$query2 = $konekcija->prepare("SELECT * FROM pagi LIMIT :pocetak, :prikaz");
$query2->bindValue(':pocetak', (int) $pocetak, PDO::PARAM_INT); //odakle krecemo sa prikazivanjem stavki iz baze, npr od stavke broj 10
$query2->bindValue(':prikaz', (int) $prikaz, PDO::PARAM_INT); //koliko narednih stavki prikazujemo, npr 6, dakle vraceni rezultat je 10,11,12,13,14,15 i 16.
$query2->execute();

while ($row2 = $query2->fetch()){
    echo '<strong>'. $row2['id'] .'.) </strong>'. $row2['text'] .'<br /><br />';
}

echo '</div>';

/*------------- PRIKAZ PAGINACIJE -------------*/

echo '<div>';


// ako smo trenutno na prvoj strani, u paginaciji ne prikazujemo link ka prethodnoj strani, jer ona ne postoji

if ($strukupno > $trenutnastr && $trenutnastr <= 1){
    echo '<span class="inactive">PRVA | <<< Prethodna</span> | Strana '. $trenutnastr .' od '. $strukupno .'  |  <a class="active" href="?page='. $naredna .'">Sledeća >>></a> | <a class="active" href="?page='. $strukupno .'">POSLEDNJA</a>';
}

//ukoliko nemamo dovoljno unosa u bazi, u paginacijicemo prikazati da postoji jedna strana, a  mozemo ostaviti i echo ""; da ne prikazujemo paginaciju uopste u tom slucaju

elseif ($trenutnastr == $strukupno && $strukupno == 1){
	echo 'Strana '. $trenutnastr .' od '. $strukupno .'';
}

//ukoliko nismo ni na prvoj, a ni na poslednjoj strani, prikazacemo linkove i za prethodnu i za narednu stranu

elseif ($strukupno > $trenutnastr && $trenutnastr >= 1){
	echo '<a class="active" href="?page=1">PRVA</a> | <a class="active" href="?page='. $prethodna .'"> <<< Prethodna</a> | Strana '. $trenutnastr .' od '. $strukupno .' | <a class="active" href="?page='. $naredna .'"> Sledeća >>></a> | <a class="active" href="?page='. $strukupno .'">POSLEDNJA</a>';
}

// ako se nalazimo na poslednjoj strani, u paginaciji ce biti prikazan samo link ka prethodnoj strani, jer naredna ne postoji

elseif ($strukupno == $trenutnastr){
	echo '<a class="active" href="?page=1">PRVA</a> | <a class="active" href="?page='. $prethodna .'"> <<< Prethodna</a> | Strana '. $trenutnastr .' od '. $strukupno .' | <span class="inactive">Sledeća >>> | POSLEDNJA</span>';
}

echo '</div>';

?>
</body>
</html>